<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\Auth;

class CheckAdmin
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        // Require authentication.
        if (!Auth::check()) {
            abort(403);
        }

        // Allow only admin-like user types.
        // This app uses the `users.type` column (e.g., Owner/Admin).
        $type = strtolower((string) Auth::user()->type);

        if (!in_array($type, ['owner', 'admin'], true)) {
            abort(403);
        }

        return $next($request);
    }
}
