@extends('admin.layouts.adminmaster')

@section('title', 'Advertisement Settings')
@section('head', 'Advertisement Settings')

@section('content')
    <div class="">
        @include('partials.msg')
        @include('partials.errormsg')
        
            {{-- Advertisement settings --}}
        

            <div class="card border-success p-4 mt-4 mb-4">
                <h4 class="card-title">Leaderboard & side ad code</h4>
                <small class="text-info"><em>Use HTML link or get Google Adsense code here.</em></small>
                <div class="card-body">
                    <form action="{{ route('upads', $ads->id) }}" class="form-horizontal form-label-left" method="POST">
                        @csrf
                        @method('PUT')
                        <div class="form-group row">
                            <label class="control-label col-md-4" for="leaderads">Leaderboard ad<br>
                                <small>It will appear on homepage to all visitors.</small>
                            </label>
                            <div class="col-md-8">
                                <textarea name="leaderads" class="resizable_textarea form-control" rows="4">{{ old('leaderads', $ads->leaderads) }}</textarea>
                            </div>
                        </div>
                        
                        <div class="form-group row">
                            <label class="control-label col-md-4" for="sideads">Sidebar ad<br>
                                <small>It will appear on homepage to all visitors.</small>
                            </label>
                            <div class="col-md-8">
                                <textarea name="sideads" class="resizable_textarea form-control" rows="4">{{ old('sideads', $ads->sideads) }}</textarea>
                            </div>
                        </div>
                        
                        {{--Form button--}}
                        
                        <div class="item form-group">
                            <div class="col-md-6 col-sm-6 offset-md-3">
                                <button class="btn btn-primary" type="reset">Reset</button>
                                <button type="submit" class="btn btn-success">Submit</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
                
@endsection