@extends('admin.layouts.adminmaster')

@section('title', 'Category Management')
@section('head', 'Category Management')

@section('content')
    <div class="container">
        @include('partials.msg')
        @include('partials.errormsg')
        <div class="row">
            <div class="col-md-9">
                <h2>Categories</h2>
                <table class="table table-hover">
                    <thead class="bg-warning">
                        <tr>
                            <th>#</th>
                            <th>Name</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($categories as $category)
                        <tr>
                            <td>{{ $loop->index + 1 }}</td>
                            <td><a href="{{ route('category.show', $category->name) }}">{{ $category->name }}</a></td>
                            <td>
                                <!-- Edit & delete button -->
                                <div class="float-left">
                                    <button type="button" class="btn btn-success" data-toggle="modal" data-target="#modal{{$category->id}}">
                                        Edit
                                    </button>

                                    <button type="button" class="btn btn-danger" data-toggle="modal" data-target="#delete{{$category->id}}">
                                        Delete
                                    </button>
                                </div>
                                @include('admin.partials.edit_category')
                                @include('admin.partials.delete_category')
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
                
            </div>
            
            <div class="col-md-3">
                <form action="{{route('category.store')}}" method="POST" class="card bg-danger text-white p-2">
                    @csrf
                    <div class="form-group">
                      <label for="name">Category name</label>
                      <input type="text" name="name" class="form-control" placeholder="Enter new category">
                    </div>
                    <button type="submit" class="btn btn-outline-light btn-lg btn-block">Submit</button>
                </form>
                
                <div class="card my-3">
                    <div class="card-header">
                        Cheap hosting
                    </div>
                    <div class="card-body">
                        <p>Shared hosting under $3/m. Or get VPS/Dedicated server for large projects.</p>
                        <a class="btn btn-success btn-block" href="https://www.wall-spot.com/web-hosting-starters/" target="_blank" rel="noopener noreferrer">Hit here</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection