<!-- Modal for edit -->
<div class="modal fade" id="modal{{$link->id}}" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Edit link</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            
            
                <form action="{{route('upsite', $link->slug)}}" method="POST">
                        @csrf
                        @method('PUT')
                    <div class="modal-body">
                        <div class="form-group">
                            <label for="category_id">Site title:</label>
                            <input type="text" class="form-control" name="title" value="{{ $link->title }}">
                            <small>Character required is min. 5 and max. 150</small>                        
                        </div>
                        <div class="form-group">
                            <label for="category_id">Site URL:</label>
                            <input type="text" class="form-control" name="url" value="{{ $link->url }}">
                            <small>Character required is max. 50</small> 
                        </div>
                        <div class="form-group">
                            <label for="category_id">Category:</label>
                            <select name="category_id" class="custom-select">
                              <option selected="">Select a category</option>
                              @foreach ($categories as $category)
                                <option value="{{ $category->id }}" {{ $category->id === $link->category_id ? ' selected' : '' }}>{{ $category->name }}</option>
                              @endforeach                      
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="category_id">Description:</label>
                            <textarea class="form-control" name="description">{{ $link->description }}</textarea>
                            <small>Character required is min. 20</small> 
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary">Save changes</button>
                    </div>                              
                    
                </form>
            
            
        </div>
    </div>
</div>