@extends('admin.layouts.adminmaster')

@section('title', 'Site Settings')
@section('head', 'Site Settings')

@section('content')
    <div class="">
        @include('partials.msg')
        @include('partials.errormsg')
        
            <div class="card border-success p-4 my-2">
                <div class="d-flex justify-content-between align-items-center">
                    <h4 class="card-title">Site settings</h4>
                </div>
                <div class="card-body">
                    <form action="{{ route('upsettings', $settings->id) }}" class="form-horizontal form-label-left" method="POST">
                        @csrf
                        @method('PUT')
                        <div class="form-group row">
                            <label class="control-label col-md-3" for="site-title">Post limit<br>
                                <small>Set the limit of posts for all users.</small>
                            </label>
                            <div class="col-md-7">
                                <input type="text" name="limitpost" class="form-control col-md-7" value="{{ old('limitpost', $settings->limitpost) }}">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="control-label col-md-3" for="site-title">Site Title<br>
                                <small>Your site title or the company name.</small>
                            </label>
                            <div class="col-md-7">
                                <input type="text" name="title" class="form-control col-md-7" value="{{ old('title', $settings->title) }}">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="control-label col-md-3" for="site-description">Site Description<br>
                                <small>Provide a description for search engines.</small>
                            </label>
                            <div class="col-md-7">                                        
                                <textarea name="description" class="resizable_textarea form-control">{{ old('description', $settings->description) }}</textarea>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="control-label col-md-3" for="about">About<br>
                                <small>A short description for footer area.</small>
                            </label>
                            <div class="col-md-7">                                        
                                <textarea name="about" class="resizable_textarea form-control">{{ old('about', $settings->about) }}</textarea>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="control-label col-md-3" for="site-message">Site Message<br>
                                <small>It will appear on homepage to all visitors.</small>
                            </label>
                            <div class="col-md-7">
                                <textarea name="sitemsg" class="resizable_textarea form-control">{{ old('sitemsg', $settings->sitemsg) }}</textarea>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="control-label col-md-3" for="right-footer-title">Footer title<br>
                                <small>Footer title on right side</small>
                            </label>
                            <div class="col-md-7">                            
                                <input type="text" name="rtitle" class="form-control col-md-7" value="{{ old('rtitle', $settings->rtitle) }}">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="control-label col-md-3" for="right-footer-msg">Footer message<br>
                                <small>Footer message on right side</small>
                            </label>
                            <div class="col-md-7">                            
                                <input type="text" name="rmsg" class="form-control col-md-7" value="{{ old('rmsg', $settings->rmsg) }}">
                            </div>
                        </div>

                        {{--Form button--}}
                        
                            <div class="item form-group">
                                <div class="col-md-6 col-sm-6 offset-md-3">
                                    <button class="btn btn-primary" type="reset">Reset</button>
                                    <button type="submit" class="btn btn-success">Submit</button>
                                </div>
                            </div>                        
                    </form>
                </div>
            </div>

        {{--Social pages--}}
        

            <div class="card border-success p-4 mt-4 mb-4">
                <h4 class="card-title">Social pages</h4>
                <div class="card-body">
                    <form action="{{ route('upsocial', $settings->id) }}" class="form-horizontal form-label-left" method="POST">
                        @csrf
                        @method('PUT')
                        <div class="form-group row">
                            <label class="control-label col-md-3" for="facebook">Facebook<br>
                                <small>Enter your Facebook username.</small>
                            </label>
                            <div class="col-md-7">
                                <input type="text" name="facebook" class="form-control col-md-7" value="{{ old('facebook', $settings->facebook) }}">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="control-label col-md-3" for="twitter">Twitter<br>
                                <small>Enter your Twitter handle.</small>
                            </label>
                            <div class="col-md-7">
                                <input type="text" name="twitter" class="form-control col-md-7" value="{{ old('twitter', $settings->twitter) }}">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="control-label col-md-3" for="linkedin">Linkedin<br>
                                <small>Enter your Linkedin username.</small>
                            </label>
                            <div class="col-md-7">
                                <input type="text" name="linkedin" class="form-control col-md-7" value="{{ old('linkedin', $settings->linkedin) }}">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="control-label col-md-3" for="blog">Blog<br>
                                <small>Include <span class="text-info">http://</span> or <span class="text-info">https://</span> with the address.</small>
                            </label>
                            <div class="col-md-7">
                                <input type="text" name="blog" class="form-control col-md-7" value="{{ old('blog', $settings->blog) }}">
                            </div>
                        </div>

                        
                        {{--Form button--}}
                        
                        <div class="item form-group">
                            <div class="col-md-6 col-sm-6 offset-md-3">
                                <button class="btn btn-primary" type="reset">Reset</button>
                                <button type="submit" class="btn btn-success">Submit</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
                
@endsection