@extends('admin.layouts.adminmaster')

@section('title', 'User Management')
@section('head', 'User Management')

@section('content')
  <div class="container">
    @include('partials.msg')
    @include('partials.errormsg')
    <div class="row mb-4">
        <div class="col-md-12">
            <h2>Users</h2>
            @if (Auth::user()->type == 'Owner')
                <div class="card bg-dark p-4 my-2 text-light">
                    <p class="text-secondary"><span class="text-light">{{ Auth::user()->name }}</span>, only you see this box. Visit the list of <a class="text-warning" href="{{ route('admins') }}">
                        Admins
                    </a></p>
                </div>
            @endif
            <table class="table table-hover">
                <thead class="bg-warning">
                    <tr>
                        <th>#</th>
                        <th>Name</th>
                        <th>Posts</th>
                        <th>Actions</th>                        
                        <th>Moderate user</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse ($users as $user)
                    <tr>
                        <td>{{ $loop->index + 1 }}</td>
                        <td>{{ $user->name }}</td>
                        <td><span class="badge-pill badge-warning">{{ $user->links()->count() }}</span></td>
                        <td>
                            <!-- Edit & delete button -->
                            <div class="float-left">
                                <button type="button" class="btn btn-info" data-toggle="modal" data-target="#modal{{$user->id}}">
                                    See
                                </button>

                                <button type="button" class="btn btn-danger" data-toggle="modal" data-target="#delete{{$user->id}}">
                                    Delete
                                </button>
                            </div>
                            
                            @include('admin.partials.see_user')
                            @include('admin.partials.delete_user')
                        </td>
                        
                        <td>
                            <button type="button" class="btn btn-danger" data-toggle="modal" data-target="#edit{{$user->id}}">
                                Assign
                            </button>
                            @include('admin.partials.edit_user')
                        </td>
                    </tr>
                    @empty
                        There is no records available now.
                    @endforelse
                </tbody>
            </table>
            {{ $users->links() }}
        </div>
        
    </div>
  </div>
@endsection