@extends('layouts.app')

@section('title', 'Add new')

@section('content')
    <div class="container">
      @include('partials.errormsg')
        
        <div class="row justify-content-center">
            <div class="col-md-8">
                <form action="{{route('link.store')}}" method="POST" enctype="multipart/form-data">
                  @csrf
                  <div class="form-group">
                    <label for="title">Site title <span class="text-danger">*</span></label>
                    <input type="text" name="title" class="form-control" placeholder="Enter site title" value="{{ old('title') }}">
                  </div>
                  <div class="form-row">
                    <div class="form-group col-md-6">
                      <label for="url">Site URL</label>
                      <input type="text" name="url" class="form-control" placeholder="Enter site URL" value="{{ old('url') }}">
                    </div>
                    <div class="form-group col-md-6">
                      <label for="category_id">Category <span class="text-danger">*</span></label>
                      <select name="category_id" class="custom-select">
                        <option selected="">Select a category</option>
                        @foreach ($categories as $category)
                          <option value="{{ $category->id }}">{{ $category->name }}</option>
                        @endforeach                      
                      </select>
                    </div>
                  </div>
                  <div class="form-row">
                    <div class="form-group col-md-6">
                      <label for="phone">Phone number</label>
                      <input type="text" name="phone" class="form-control" placeholder="Enter phone no." value="{{ old('phone') }}">
                    </div>
                    <div class="form-group col-md-6">
                        <label for="email">Email</label>
                        <input type="text" name="email" class="form-control" placeholder="Enter email address" value="{{ old('email') }}">
                    </div>
                  </div>
                  <div class="form-row">
                    <div class="form-group col-md-6">
                      <label for="icon">Site icon</label>
                      <input type="file" name="icon">
                    </div>
                    <div class="form-group col-md-6">
                      <label for="address">Address</label>
                      <textarea name="address" class="form-control" cols="30" rows="4" placeholder="Enter address"></textarea>
                    </div>
                  </div>
                  <div class="form-group">
                    <label for="description">Site description <span class="text-danger">*</span></label>
                    <textarea name="description" class="form-control" cols="30" rows="10" placeholder="Enter site description">
                      {{old('description')}}
                    </textarea>
                  </div>
                  <button type="submit" class="btn btn-primary btn-block">Submit</button>
                </form>
            </div>
        </div>
    </div>
@endsection