@extends('layouts.app')

@section('title', $link->title)
@section('linkrel')
    <link rel="stylesheet" href="{{asset('css/star-comment.css')}}">
    <link rel="stylesheet" href="{{asset('css/stars.css')}}">
@endsection

@section('headad')
    <div class="py-2 text-center bg-light">
        {!! $admin->leaderads !!}
    </div>
@endsection
@section('content')
    <div class="container">
        {{--Site messages--}}
        @include('partials.msg')
        {{--Site messages ends--}}

        <div class="row justify-content-center">
            <div class="col-md-8">
                <div class="card">
                    <h4 class="card-header bg-light">
                        {{ $link->title }}
                    </h4>
                    <div class="card-body">
                        <p class="card-text">
                            {!! nl2br($link->description) !!}
                        </p>
                        
                        <div class="card-text">
                            <div></p><strong>Website:</strong> <a href="{{ $link->url }}" target="_blank">{{ $link->url }}</a></div>
                            <div><strong>Phone No.:</strong> {{$link->phone}}</div>
                            <div><strong>Email:</strong> {{$link->email}}</div>
                            <div><strong>Address:</strong> {{$link->address}}</div>
                        </div>
                        <div class="card-link">
                            <strong>In category:</strong> <a href="{{ route('category.show', $link->category->slug ?? 'Un') }}">{{ $link->category->name ?? 'Uncategorized' }}</a>
                            <strong>Page views:</strong> {{$link->views}}
                        </div>
                    </div>
                </div>

                {{-- Start rating and comments --}}
                @include('partials.star_comments')
            </div>
            <div class="col-md-4">
                <div class="card">
                    <div class="card-body pt-4">
                        @if ($link->icon)
                            <img src="{{asset('images')}}/icon/{{$link->icon}}" alt="" class="img-fluid rounded">
                        @else
                            <img src="{{asset('images')}}/default/icon.png" alt="" class="img-fluid rounded">
                        @endif
                        
                        <ul class="list-unstyled mb-0 mt-2">
                            <li><strong>Website:</strong> {{ $link->url }}</li>
                        </ul>
                    </div>
                    @auth
                        @if (auth()->user()->id == $link->user_id || auth()->user()->type == 'Owner' || auth()->user()->type == 'Admin')
                            
                        
                        <div class="card-footer">
                            
                            <div class="actions form-inline">
                                <a href="{{route('link.edit', $link->slug)}}" class="btn btn-success btn-sm badge form-group m-1">Edit</a>

                                <button type="submit" class="btn btn-danger badge m-1" data-toggle="modal" data-target="#delete{{$link->id}}">Delete</button>
                                @include('links.modal.post_delete')                                
                            </div>
                            
                        </div>
                        
                        @endif
                        @endauth

                </div>
                <div class="p-4">
                    {!! $admin->sideads !!}
                </div>
            </div>
        </div>
    </div>
@endsection