@extends('layouts.app')

@section('title', 'Welcome home')

@section('content')
    <div class="container">
        <div class="card border-0 w-100 p-5">
            <div class="row">
                <div class="col-md-5 my-auto">
                    <p>{{$admin->sitemsg}}</p>
                    @include('layouts.searchform')
                </div>
                <div class="col-md-7">
                    <img class="img-fluid" src="/images/linkdir/linkdir.png" alt="LinkDir">
                </div>
            </div>
        </div>
    </div>
    
        <div class="text-center bg-light py-2">
            {!! $admin->leaderads !!}
        </div>

    <div class="container">
        <div class="text-center mt-2">
            <h4>Categories</h4>
            <hr>
            <p class="text-muted">Go through the categories to find amazing products and services.</p>
        </div>
        <div class="row">
            @forelse ($categories as $category)
                <div class="col-sm-6 col-md-6 col-lg-3">
                    <div class="card bg-dark text-white text-center my-2">
                        {{-- <div class="card-header">
                            {{ $category->name }} ({{ $category->links()->count() }})
                        </div> --}}
                        <div class="card-body">
                            <div>{{ $category->name }} ({{ $category->links()->count() }})</div>
                            <div class="my-1">
                                <a class="btn btn-dark" href="{{ route('category.show', $category->slug) }}">Visit</a>
                            </div>
                        </div>
                    </div>
                </div>
            @empty
                <p class="col-md-12 bg-warning py-2 text-center text-light rounded">There are no categories yet !</p>
            @endforelse
        </div>

        <div class="row">
            @forelse ($links as $item)
                <div class="col-md-6">
                    @include('partials.item_list')
                </div>
            @empty
                
            @endforelse
        </div>
    </div>
@endsection