<?php

namespace App\Http\Controllers;

use App\Link;
use App\Category;
use App\AdminSet;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {
        $usersfill = Link::where('user_id', Auth::user()->id)->first();
        $links = Link::where('user_id', Auth::user()->id)->simplePaginate(10);
        $categories = Category::all();
        return view('home', compact('usersfill', 'links', 'categories'));
    }
}
