<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Cviebrock\EloquentSluggable\Sluggable;

class Link extends Model
{
	use Sluggable;

    protected $fillable=['title', 'user_id', 'category_id', 'url', 'urlslug', 'icon', 'reported', 'star', 'phone', 'email', 'address', 'description'];

	public function sluggable(): array
    {
        return [
            'slug' => [
                'source' => 'urlslug'
            ]
        ];
    }

    public function getRouteKeyName()
    {
        return 'slug';
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function category()
    {
        return $this->belongsTo(Category::class);
    }

    public function stars()
    {
        return $this->hasMany(Star::class);
    }

    public function comments()
    {
        return $this->hasMany(Comment::class);
    }
}