<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateAdminSetsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('admin_sets', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('title')->nullable();
            $table->mediumText('description')->nullable();
            $table->string('limitpost')->default(5);
            $table->string('about')->nullable();
            $table->string('url')->nullable();
            $table->string('sitemsg')->nullable();
            $table->string('rtitle')->nullable();
            $table->string('rmsg')->nullable();
            $table->mediumText('leaderads')->nullable();
            $table->mediumText('sideads')->nullable();
            $table->string('facebook')->nullable();
            $table->string('twitter')->nullable();
            $table->string('linkedin')->nullable();
            $table->string('blog')->nullable();
            $table->timestamps();
        });

        // Inserting data
        DB::table('admin_sets')->insert(
            array(
                'title'=>'LinkDIR',
                'description'=>'A simple site listing. Website Directory to find the best sites.',
                'about'=>'Easy site listings for best results.',
                'sitemsg'=>'We have a large collection of best site. Try searching the directory.',
                'rtitle'=>'Contact Us',
                'rmsg'=>'contact@site.com',
                'leaderads'=>'<a href="http://www.wall-spot.com/likes/hostinger/" target="_blank"><img class="img-fluid" src="/images/linkdir/hostingeren-728x90.png" alt="Low cost web hosting"></a>',
                'sideads'=>'Starting a new project? Lets look for a low-cost <a href="http://www.wall-spot.com/likes/bluehost/" target="_blank">web hosting plan</a> <div class="mt-2"><a href="http://www.gopickhost.com/" target="_blank"><img class="img-fluid" src="/images/default/side ad hosting.png"></a></div>',
            )
        );
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('admin_sets');
    }
}
