@extends('admin.layouts.adminmaster')

@section('title', 'Admin Panel')
@section('head', 'Admin Panel')

@section('content')
  <div class="container">
    @include('partials.msg')
    @include('partials.errormsg')
    <div class="row mb-4">
        <div class="col-md-6 my-2">
            <h4><i class="fa fa-users"></i> Latest users registered</h4>
                
                    <table class="table table-primary">
                        <thead>
                            <tr>
                                <th>Name</th>
                                <th>Registered</th>
                            </tr>
                        </thead>
                        @foreach ($users as $user)
                            <tr>
                                <td>{{ $user->name }}</td>
                                <td>{{ $user->created_at->diffForHumans() }}</td>
                            </tr>
                        @endforeach                      
                    </table>
        </div>

        <div class="col-md-6 my-2">
            <h4><i class="fa fa-desktop"></i> Latest records</h4>
                
                    <table class="table table-primary">
                        <thead>
                            <tr>
                                <th>Title</th>
                                <th>Added</th>
                            </tr>
                        </thead>
                        @forelse ($links as $link)
                            <tr>
                                <td>{{ $link->title }}</td>
                                <td>{{ $link->created_at->diffForHumans() }}</td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="2">No record found.</td>
                            </tr>
                        @endforelse                        
                    </table>
        </div>

        <div class="col-md-6 my-2">
            <h4><i class="fa fa-cubes"></i> Categories</h4>
                
                    <table class="table table-primary">
                        <thead>
                            <tr>
                                <th>Name</th>
                                <th>Modified</th>
                            </tr>
                        </thead>
                        @forelse ($categories as $category)
                            <tr>
                                <td>{{ $category->name }} <span class="badge-light badge-pill">{{ $category->links()->count() }}</span></td>
                                <td>{{ $category->created_at->diffForHumans() }}</td>
                            </tr>
                        @empty
                        <tr>
                            <td colspan="2">No category is created yet.</td>
                        </tr>
                        @endforelse                        
                    </table>
                
        </div>
        
    </div>
  </div>
@endsection