@extends('layouts.app')

@section('title', 'Member dashboard')

@section('content')
<div class="container">
    @include('partials.msg')
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header">{{ __('Dashboard') }}</div>
{{$admin->sidead}}
                <div class="card-body">
                    @if (session('status'))
                        <div class="alert alert-success" role="alert">
                            {{ session('status') }}
                        </div>
                    @endif
                    
                    <p class="card-text">
                        <strong>{{ Auth::user()->name }}</strong> {{ __('Welcome to the dashboard!') }}
                    </p>

                </div>
            </div>

            <div class="card my-2">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h4>
                        {{ __('Posts count') }}
                    </h4>

                    <h6 class="card-subtitle text-muted">
                        @if ( Auth::user()->links()->count() < $admin->limitpost)
                            You have {{ Auth::user()->links->count() }}/{{$admin->limitpost}} sites.
                        @else
                            Ohh! Out of the slots.
                        @endif
                    </h6>
                </div>

                <div class="">
                    <ul class="list-group list-group-flush">
                        @foreach ($links as $link)
                            <li class="list-group-item d-flex justify-content-between">
                                <p>
                                    {{ $link->title }}
                                    <span class="text-success">{{$link->star}}</span>
                                </p>
                                <div>
                                    <small class="mr-2">
                                        {{ $link->category->name }}
                                    </small>
                                    <a href="{{ route('link.show', $link->slug) }}" class="btn btn-warning btn-sm">
                                        See
                                    </a>
                                </div>
                            </li>
                        @endforeach                        
                    </ul>
                </div>                
            </div>
            {{ $links->links() }}
        </div>
    </div>
</div>
@endsection
