<!doctype html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- CSRF Token -->
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <meta name="title" content="{{ $admin->title }}">
    <meta name="description" content="{{ $admin->description }}">

    <title>{{ config('app.name', 'LinkDir') }} | @yield('title')</title>

    <!-- Favicon icon -->
    <link rel="icon" type="image/png" sizes="16x16" href="{{asset('images/linkdir/favicon.png')}}">

    <!-- Scripts -->
    <script src="{{ asset('js/app.js') }}" defer></script>

    <!-- Fonts -->
    <link rel="dns-prefetch" href="//fonts.gstatic.com">
    <link href="https://fonts.googleapis.com/css?family=Nunito" rel="stylesheet">

    <!-- Font Awesome -->
    <link href="{{ asset('css/admin/font-awesome.min.css') }}" rel="stylesheet">

    <!-- Styles -->
    <link href="{{ asset('css/bootstrap.min.css') }}" rel="stylesheet">
    <link href="{{ asset('css/socialicons.css') }}" rel="stylesheet">

    <!-- Bootstrap JS file -->
    <script src="{{ asset('js/admin/bootstrap.bundle.min.js') }}"></script>
    @yield('linkrel')

</head>
<body>
    <div id="app">
        @include('layouts.navbar')

        @yield('headad')
        
        <main class="my-4">
            @yield('content')
        </main>
    </div>
    <div class="text-center bg-light py-2">
        <div class="container">
            {!!$admin->leaderads!!}
        </div>
    </div>
    <footer class="bg-dark py-4 text-light">
        <div class="container">
            <div class="row">
                <div class="col-md-6">
                    <h4><a class="text-light" href="{{route('main')}}">{{ config('app.name', 'LinkDir') }}</a></h4>
                    <p>{{ $admin->description }}</p>
                </div>
                <div class="col-md-2">
                    <h4>Pages</h4>
                    <ul class="list-unstyled">                        
                        
                        @foreach ($pages as $page)
                        <li><a href="{{ route('page.show', $page->slug) }}" class="text-light">{{ $page->title }}</a></li>
                        @endforeach
                        <li>
                            <a href="{{url('sitemap')}}" target="_blank" class="text-light" rel="noopener noreferrer">Sitemap</a>
                        </li>
                        
                    </ul>
                </div>
                <div class="col-md-4 text-right">
                    <h4>{{ $admin->rtitle }}</h4>
                    <p>{{ $admin->rmsg }}</p>
                    @if (!empty($admin->facebook))
                        <a href="https://facebook.com/{{$admin->facebook}}" class="fa fa-facebook so"></a>
                    @endif
                    @if (!empty($admin->twitter))
                        <a href="https://twitter.com/{{$admin->twitter}}" class="fa fa-twitter so"></a>
                    @endif
                    @if (!empty($admin->linkedin))
                        <a href="https://linkedin.com/{{$admin->linkedin}}" class="fa fa-linkedin so"></a>
                    @endif
                    @if (!empty($admin->blog))
                        <a href="{{$admin->blog}}" class="fa fa-book so"></a>
                    @endif
                                    
                </div>
            </div>
        </div>
    </footer>
    <div class="text-center text-secondary bg-dark py-3">
        <div class="container">
            <div class="row">
                <div class="col-md-6 text-left">
                    <small>&copy; <strong>{{config('app.name', 'LinkDir')}}</strong> {{date('Y')}} All rights reserved.</small>
                </div>
                <div class="col-md-6 text-right">
                    <small>Made with <i class="fa fa-heart text-danger"></i> and developed by <a class="text-secondary" href="https://webfuelcode.wall-spot.com" target="_blank" rel="noopener noreferrer"><strong>WebFuelCode</strong></a></small>
                </div>
            </div>
        </div>
    </div>
</body>
</html>