@extends('layouts.app')

@section('title', 'Categories')

@section('content')
    <div class="container">
        <div class="row">
            <div class="col-md-9 order-md-last">
                <div class="pb-2">
                    <h2>
                        Lists
                    </h2>
                    
                </div>
                <div class="">
                    @forelse ($links as $link)
                            <div class="card bg-light border-0 mb-2">                                
                                <div class="card-body row">
                                    <div class="col-2">
                                        @if ($link->icon)
                                            <img src="{{asset('images')}}/icon/{{$link->icon}}" alt="" class="img-fluid rounded">
                                        @else
                                            <img src="{{asset('images')}}/default/icon.png" alt="" class="img-fluid rounded">
                                        @endif
                                    </div>
                                    <div class="col-10">
                                        <h5><i class="fa fa-hand-o-right"></i> <a href="{{ route('link.show', $link->slug) }}">{{ $link->title }}</a></h5>
                                        <p class="card-text">
                                            {{ substr($link->description, 0, 150) }}
                                        </p>
                                    </div>
                                </div>                              
                            </div>
                    @empty
                                Currently, there are no records.
                            
                    @endforelse
                    
                </div>
                {{ $links->links() }}
            </div>
            <div class="col-md-3">
                <h2 class="pb-2">
                    Categories
                </h2>
                
                <ul class="list-group">
                    <a class="list-group-item {{ Request::is('link') ? 'active' : '' }}" href="{{ route('link.index') }}">View all</a>
                    @forelse ($categories as $category)
                            
                        <a class="list-group-item d-flex justify-content-between align-item-center {{ Request::is('category/' . $category->slug) ? 'active' : '' }}" href="{{route('category.show', $category->slug)}}">{{$category->name}} <span class="badge badge-light">{{$category->links->count()}}</span></a>
                    @empty
                    There are no categories yet.
                        
                    @endforelse
                </ul>

                <div class="p-4">
                    {!! $admin->sideads !!}
                </div>
            </div>
        </div>
    </div>
@endsection